<?php
session_start(); // Start the session
require 'headers.php';

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Decode JSON input
    $input = file_get_contents('php://input');
    error_log("Raw Input: $input");

    if (!$input) {
        echo json_encode(['success' => false, 'message' => 'No data received']);
        exit;
    }

    $data = json_decode($input, true);

    if (!isset($data['code']) || empty($data['code'])) {
        echo json_encode(['success' => false, 'message' => 'Coupon code is required']);
        exit;
    }

    $couponCode = trim($data['code']);

    try {
        // Fetch coupon details from database
        $stmt = $pdo->prepare("SELECT discount, expiry_date, status FROM coupon WHERE code = :code LIMIT 1");
        $stmt->bindParam(':code', $couponCode);
        $stmt->execute();
        $coupon = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$coupon) {
            echo json_encode(['success' => false, 'message' => 'Invalid coupon code']);
            exit;
        }

        // Check if the coupon is still valid
        $currentDate = date('Y-m-d'); // Get current date in YYYY-MM-DD format
        if ($coupon['expiry_date'] < $currentDate) {
            echo json_encode(['success' => false, 'message' => 'Coupon has expired']);
            exit;
        }

        if ($coupon['status'] !== 'active') {
            echo json_encode(['success' => false, 'message' => 'Coupon is not active']);
            exit;
        }

        // Store coupon code in session
        $_SESSION['couponcode'] = $coupon['discount'];

        // Coupon is valid, return discount amount
        echo json_encode([
            'success' => true,
            'discount' => $coupon['discount'],
            'coupon_code' => $_SESSION['couponcode']
        ]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database query failed']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>
