<?php
require 'headers.php';

/**
 * Retrieves reviews for a given product.
 *
 * @param array $data The request data containing the product ID.
 * @return array The response containing the reviews or an error message.
 */
function getProductReviews($data) {
    global $pdo;

    if (!isset($data['product_id']) || empty($data['product_id'])) {
        return ['success' => false, 'message' => 'Product ID is required'];
    }

    try {
        $stmt = $pdo->prepare("
            SELECT r.text, r.created_at, u.name
            FROM reviews r
            LEFT JOIN users u ON r.user_id = u.unique_id
            WHERE r.product_id = :product_id
            ORDER BY r.created_at DESC
        ");

        $stmt->execute(['product_id' => $data['product_id']]);
        $reviews = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return ['success' => true, 'reviews' => $reviews];
    } catch (PDOException $e) {
        return [
            'success' => false,
            'message' => 'Error fetching reviews',
            'error' => $e->getMessage()
        ];
    }
}

// Get POSTed JSON data
$data = json_decode(file_get_contents('php://input'), true);
$response = getProductReviews($data);
echo json_encode($response);
