<?php
session_start(); // Ensure session is started
require 'headers.php';
require_once 'stripe-php/init.php'; // Ensure Stripe SDK is installed

use Stripe\StripeClient;

// Initialize Stripe
$stripe = new StripeClient('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'); // Replace with your actual secret key

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    if (!$input) {
        echo json_encode(['success' => false, 'message' => 'No data received']);
        exit;
    }

    $data = json_decode($input, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['success' => false, 'message' => 'Invalid JSON input']);
        exit;
    }

    if (!isset($data['pay']) || $data['pay'] !== 'pay') {
        echo json_encode(['success' => false, 'message' => 'Invalid request']);
        exit;
    }

    if (!isset($_SESSION['unique_id'])) {
        echo json_encode(['success' => false, 'message' => 'User not authenticated']);
        exit;
    }

    $unique_id = $_SESSION['unique_id'];

    // Retrieve product details from cart
    $stmt = $pdo->prepare("SELECT product_id, cart_id, quantity, size, color FROM cart WHERE unique_id = :unique_id");
    $stmt->execute(['unique_id' => $unique_id]);
    $cartItems = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$cartItems) {
        echo json_encode(['success' => false, 'message' => 'No items in cart']);
        exit;
    }

    // Initialize payment variables
    $totalPayment = 0;
    $productDetails = [];

    foreach ($cartItems as $item) {
        try {
            // Fetch product details from Stripe
            $product = $stripe->products->retrieve($item['product_id']);

            // Fetch associated prices
            $prices = $stripe->prices->all(['product' => $item['product_id']]);

            // Get the first price (assuming one price per product)
            $price = $prices->data[0] ?? null;

            if ($price) {
                $unitAmount = $price->unit_amount / 100; // Convert to dollars
                $totalPayment += $unitAmount * $item['quantity']; // Adjust for quantity

                $productDetails[] = [
                    'cart_id' => $item['cart_id'],
                    'product_id' => $product->id,
                    'name' => $product->name,
                    'description' => $product->description,
                    'images' => $product->images,
                    'price' => [
                        'id' => $price->id,
                        'unit_amount' => $unitAmount,
                        'currency' => strtoupper($price->currency)
                    ],
                    'quantity' => $item['quantity'],
                    'size' => $item['size'],
                    'color' => $item['color']
                ];
            }
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'message' => 'Error retrieving product data: ' . $e->getMessage()]);
            exit;
        }
    }

    // Apply coupon discount if available
    if (isset($_SESSION['couponcode']) && is_numeric($_SESSION['couponcode'])) {
        $discount = $_SESSION['couponcode']; // Get discount percentage (e.g., 10 for 10%)
        $discountAmount = ($totalPayment * $discount) / 100; // Calculate discount
        $totalPayment -= $discountAmount; // Deduct from total
    }

    // Generate unique payment reference
    $payment_ref = 'PAY' . time() . rand(1000, 9999);

    // Store payment details in session
    $_SESSION['pay_ref'] = $payment_ref;
    $_SESSION['pay_amt'] = $totalPayment; // New amount after discount

    // Move items from cart to ordered table
    $insertStmt = $pdo->prepare("INSERT INTO ordered 
        (unique_id, product_id, cart_id, quantity, size, color, tracking, status, payment_ref) 
        VALUES (:unique_id, :product_id, :cart_id, :quantity, :size, :color, 'pending', 'processing', :payment_ref)");

    foreach ($cartItems as $item) {
        $insertStmt->execute([
            'unique_id' => $unique_id,
            'product_id' => $item['product_id'],
            'cart_id' => $item['cart_id'],
            'quantity' => $item['quantity'],
            'size' => $item['size'],
            'color' => $item['color'],
            'payment_ref' => $payment_ref
        ]);
    }

    // Clear the cart after order processing
    $pdo->prepare("DELETE FROM cart WHERE unique_id = :unique_id")->execute(['unique_id' => $unique_id]);

    // Return success response
    echo json_encode([
        'success' => true,
        'message' => 'Order moved to pending',
        'payment_ref' => $payment_ref,
        'total_amount' => $totalPayment,
        'discount_applied' => isset($_SESSION['couponcode']) ? $_SESSION['couponcode'] . '%' : 'No discount',
        'products' => $productDetails
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>
