<?php
require 'headers.php';
require_once 'stripe-php/init.php'; // Ensure Stripe SDK is installed




$unique_id = $_SESSION['unique_id'];

// Retrieve all orders for the user
$stmt = $pdo->prepare("SELECT * FROM ordered WHERE unique_id = :unique_id AND tracking = 'paid' ORDER BY created_at DESC");
$stmt->execute(['unique_id' => $unique_id]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$orders) {
    echo json_encode(['success' => false, 'message' => 'No orders found']);
    exit;
}

$orderDetails = [];


// Initialize the Stripe client
$stripe = new \Stripe\StripeClient('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');
foreach ($orders as $order) {
    try {
        // Fetch product details from Stripe
        $product = $stripe->products->retrieve($order['product_id']);
        $prices = $stripe->prices->all(['product' => $order['product_id']]);
        $price = $prices->data[0] ?? null;

        if ($price) {
            $unitAmount = $price->unit_amount / 100; // Convert to dollars
            $finalPrice = $unitAmount * $order['quantity']; // Total price based on quantity

            $orderDetails[] = [
                'order_id' => $order['id'],
                'product_id' => $product->id,
                'name' => $product->name,
                'description' => $product->description,
                'images' => $product->images,
                'initial_price' => [
                    'id' => $price->id,
                    'unit_amount' => $unitAmount,
                    'currency' => strtoupper($price->currency)
                ],
                'quantity' => $order['quantity'],
                'final_price' => $finalPrice,
                'color' => $order['color'],
                'size' => $order['size'],
                'tracking' => $order['tracking'],
                'status' => $order['status'],
                'payment_ref' => $order['payment_ref'],
                'order_date' => $order['order_date'],
                'pre_delivery' => $order['pre_delivery'],
                'delivery_date' => $order['delivery_date'],
                'created_at' => $order['created_at']
            ];
        }
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Error retrieving product data: ' . $e->getMessage()]);
        exit;
    }
}

// Return response
echo json_encode([
    'success' => true,
    'orders' => $orderDetails
]);
?>
