<?php
require 'headers.php';



$unique_id = $_SESSION['unique_id']; // Get the unique ID from the session

// Validate and retrieve POST data
$data = json_decode(file_get_contents('php://input'), true);

$name = $data['name'] ?? null;
$username = $data['username'] ?? null;
$number = $data['number'] ?? null;
$billing = $data['billing'] ?? null;

// Validate required fields
if (!$name || !$username || !$number || !$billing) {
    echo json_encode(['success' => false, 'message' => 'All fields are required']);
    exit;
}

try {
    // Update user details in the database
    $stmt = $pdo->prepare("UPDATE users SET name = :name, username = :username, number = :number, billing = :billing WHERE unique_id = :unique_id");
    $stmt->execute([
        ':name' => $name,
        ':username' => $username,
        ':number' => $number,
        ':billing' => $billing,
        ':unique_id' => $unique_id
    ]);

    // Check if any rows were updated
    if ($stmt->rowCount() > 0) {
        // Fetch the updated data
        $stmt = $pdo->prepare("SELECT name, username, number, billing FROM users WHERE unique_id = :unique_id");
        $stmt->execute([':unique_id' => $unique_id]);
        $updatedData = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return success response with updated data
        echo json_encode([
            'success' => true,
            'message' => 'Profile has been updated successfully',
            'data' => $updatedData
        ]);
    } else {
        // No rows were updated (likely the data is unchanged)
        echo json_encode([
            'success' => false,
            'message' => 'No changes were made to the profile'
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error updating profile',
        'error' => $e->getMessage()
    ]);
}
