<?php
require 'headers.php';

$unique_id = $_SESSION['unique_id'];

// Retrieve and validate POST data
$data = json_decode(file_get_contents('php://input'), true);
$cart_id = $data['cart_id'] ?? null;

if (!$cart_id) {
    echo json_encode(['success' => false, 'message' => 'Cart ID is required']);
    exit;
}

try {
    // Check if the product exists in the user's cart
    $stmt = $pdo->prepare("SELECT cart_id FROM cart WHERE cart_id = :cart_id AND unique_id = :unique_id");
    $stmt->execute([':cart_id' => $cart_id, ':unique_id' => $unique_id]);
    $cartItem = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$cartItem) {
        echo json_encode(['success' => false, 'message' => 'Product not found in cart']);
        exit;
    }

    // Delete the product from the cart
    $stmt = $pdo->prepare("DELETE FROM cart WHERE cart_id = :cart_id AND unique_id = :unique_id");
    $stmt->execute([':cart_id' => $cart_id, ':unique_id' => $unique_id]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'This product has been removed from your cart']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to remove product from cart']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error removing product from cart', 'error' => $e->getMessage()]);
}
