<?php
require 'headers2.php';

// Initialize Stripe
$stripe = new \Stripe\StripeClient('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'); // Replace with your actual secret key

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);
$categoryToFind = $data['category'] ?? null; // Extract category

if (!$categoryToFind) {
    echo json_encode(['status' => 'error', 'message' => 'Category is required.']);
    exit;
}

try {
    // ✅ Fetch all products from Stripe
    $products = $stripe->products->all(['limit' => 100, 'active' => true]); // Increase limit if needed

    // ✅ Filter products based on metadata['category']
    $matchingProducts = [];

    foreach ($products->data as $product) {
        if (isset($product->metadata['category']) && $product->metadata['category'] === $categoryToFind) {
            // ✅ Fetch associated prices
            $prices = $stripe->prices->all(['product' => $product->id]);

            $matchingProducts[] = [
                'id' => $product->id,
                'name' => $product->name,
                'description' => $product->description,
                'images' => $product->images,
                'prices' => array_map(function ($price) {
                    return [
                        'id' => $price->id,
                        'unit_amount' => $price->unit_amount / 100, // Convert cents to dollars
                        'currency' => strtoupper($price->currency)
                    ];
                }, $prices->data)
            ];
        }
    }

    if (!empty($matchingProducts)) {
        echo json_encode(['status' => 'success', 'data' => $matchingProducts]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No products found for this category.']);
    }
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Stripe error: ' . $e->getMessage()]);
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
}
?>
