<?php
require 'headers.php';




$unique_id = $_SESSION['unique_id']; // Get the user's unique ID from the session

// Stripe initialization
$stripe = new \Stripe\StripeClient('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');

try {
    // Fetch cart items for the user
    $stmt = $pdo->prepare("SELECT cart_id, product_id, quantity, size, color, created FROM cart WHERE unique_id = :unique_id ORDER BY created DESC");
    $stmt->execute(['unique_id' => $unique_id]);
    $cartItems = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$cartItems) {
        echo json_encode(['success' => true, 'data' => [], 'total_payment' => 0, 'total_items' => 0, 'message' => 'No items in cart']);
        exit;
    }

    $totalPayment = 0;
    $totalItems = 0;
    $productDetails = [];

    foreach ($cartItems as $item) {
        try {
            // Fetch product details from Stripe
            $product = $stripe->products->retrieve($item['product_id']);

            // Fetch associated price
            $prices = $stripe->prices->all(['product' => $item['product_id']]);
            $price = $prices->data[0] ?? null;

            if ($price) {
                $unitAmount = $price->unit_amount / 100; // Convert to dollars
                $subtotal = $unitAmount * $item['quantity'];
                $totalPayment += $subtotal;
                $totalItems += $item['quantity'];

                $productDetails[] = [
                    'cart_id' => $item['cart_id'],
                    'product_id' => $product->id,
                    'name' => $product->name,
                    'description' => $product->description,
                    'images' => $product->images,
                    'quantity' => $item['quantity'],
                    'size' => $item['size'],
                    'color' => $item['color'],
                    'price' => [
                        'id' => $price->id,
                        'unit_amount' => $unitAmount,
                        'currency' => strtoupper($price->currency),
                        'subtotal' => $subtotal
                    ],
                    'created' => $item['created']
                ];
            }
        } catch (\Stripe\Exception\ApiErrorException $e) {
            continue; // Skip this item if there's an error with Stripe
        }
    }

    // Send JSON response
    echo json_encode([
        'success' => true,
        'data' => $productDetails,
        'total_payment' => $totalPayment,
        'total_items' => $totalItems
    ]);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Error fetching cart items']);
}
?>
