<?php
require 'headers2.php';

// Define the base URL for images (ending with a slash)
$baseImageUrl = "https://admin.wittynailtip.com/banner/uploads/";

try {
    $stmt = $pdo->prepare("SELECT img1, text1, btn1, img2, text2, btn2, img3, text3, btn3 FROM banner LIMIT 1");
    $stmt->execute();
    $banner = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($banner) {
        // Prepend the base URL and encode only the filename (not the whole URL)
        foreach (['img1', 'img2', 'img3'] as $imgField) {
            if (!empty($banner[$imgField])) {
                // Extract the filename
                $filename = basename($banner[$imgField]); 
                // Append encoded filename to the base URL
                $banner[$imgField] = $baseImageUrl . rawurlencode($filename);
            }
        }

        echo json_encode(["success" => true, "data" => $banner]);
    } else {
        echo json_encode(["success" => false, "message" => "No banners found"]);
    }
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => "Query failed: " . $e->getMessage()]);
}
?>
