<?php
require_once 'stripe-php/init.php';

// Stripe API Key
\Stripe\Stripe::setApiKey('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'); // Replace with your Stripe Secret Key

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Database connection
    $conn = new mysqli('localhost', 'lxiernde_witty', 'Wittynail2024.', 'lxiernde_witty');

    if ($conn->connect_error) {
        die(json_encode(['success' => false, 'message' => 'Database connection failed.']));
    }

    // Validate input data
    $title = $_POST['title'];
    $description = $_POST['description'];
    $price = floatval($_POST['price']);
    $category = $conn->real_escape_string($_POST['category']); // Store category only

    if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
        $targetDir = "uploads/"; // Directory where images will be stored
        $fileName = basename($_FILES["image"]["name"]);
        $fileName = $_FILES["image"]["name"];
        $fileName = preg_replace('/[^a-zA-Z0-9_.-]/', '_', $fileName); // Replace spaces & special characters with "_"
        $targetFilePath = $targetDir . $fileName;
    
        // Move uploaded file to server directory
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
            $imageUrl = "https://wittynailtip.com/backend/admin/uploads/$fileName"; // Replace with your actual domain
            $imageUrl = trim($imageUrl);
        } else {
            die(json_encode(['success' => false, 'message' => 'Image upload failed.']));
        }
    } else {
        $imageUrl = null; // No image uploaded
    }
    

    try {
        // ✅ 1. Create product on Stripe
        $stripeProduct = \Stripe\Product::create([
            'name' => $title,
            'description' => $description,
             'metadata' => ['category' => $category],
           'images' => $imageUrl ? [$imageUrl] : [] // Attach uploaded image
        ]);

        // ✅ 2. Create price object on Stripe
        $stripePrice = \Stripe\Price::create([
            'unit_amount' => $price * 100, // Convert to cents
            'currency' => 'usd', // Change currency if needed
            'product' => $stripeProduct->id
        ]);

        // ✅ 3. Get Stripe product & price ID
        $stripeProductId = $stripeProduct->id;
        $stripePriceId = $stripePrice->id;

        // ✅ 4. Insert only necessary data into database
        $stmt = $conn->prepare("INSERT INTO product (product_id, price, category) VALUES (?, ?, ?)");
        $stmt->bind_param('sss', $stripeProductId, $stripePriceId, $category);

        if ($stmt->execute()) {
            echo json_encode([
                'success' => true,
                'product' => [
                    'stripe_product_id' => $stripeProductId,
                    'stripe_price_id' => $stripePriceId,
                    'category' => $category
                ]
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to insert into database.']);
        }
        $stmt->close();
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => 'Stripe error: ' . $e->getMessage()]);
    }

    $conn->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}
?>
