<?php
include 'db.php'; // Database connection
require_once 'stripe-php/init.php';
\Stripe\Stripe::setApiKey('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'); // Set your Stripe Secret Key

// Fetch orders with tracking = 'paid' and status = 'processing'
$sql = "SELECT * FROM ordered WHERE tracking = 'paid' AND status = 'processing'";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orders</title>
    <link rel="stylesheet" href="style.css?v=7">
</head>
<body>
<div class="orders-container">
    <?php while ($row = $result->fetch_assoc()): ?>
        <?php
        // Get product details from Stripe
        try {
            $product = \Stripe\Product::retrieve($row['product_id']);
            $priceObj = \Stripe\Price::retrieve($product->default_price);
            $unit_price = $priceObj->unit_amount / 100; // Convert from cents to dollars
        } catch (Exception $e) {
            $product = null;
            $unit_price = 0;
        }

        // Get user details using unique_id
        $unique_id = $row['unique_id'];
        $user_query = "SELECT name FROM users WHERE unique_id = '$unique_id'";
        $user_result = $conn->query($user_query);
        $user = $user_result->fetch_assoc();

        // Calculate total amount
        $total_price = $unit_price * $row['quantity'];
        ?>
        
        <div class="order-card">
            <?php if ($product): ?>
                <img src="<?= $product->images[0] ?? 'placeholder.jpg'; ?>" alt="Product Image">
                <div class="order-info">
                    <h3><?= strtoupper($product->name); ?></h3>
                    <p>Ordered by: <strong><?= $user['name']; ?></strong></p>
                    <p>Unit Price: $<?= number_format($unit_price, 2); ?></p>
                    <p>Quantity: <?= $row['quantity']; ?></p>
                    <p><strong>Total Amount: $<?= number_format($total_price, 2); ?></strong></p>
                   <a href="order-info.php?order_id=<?= $row['cart_id']; ?>&unique_id=<?= $row['unique_id']; ?>" class="view-details">View Details</a>
                </div>
            <?php else: ?>
                <p>Product not found in Stripe</p>
            <?php endif; ?>
        </div>
    <?php endwhile; ?>
</div>


</body>
</html>
