// Admin Panel JavaScript

$(document).ready(function () {
    const form = $('#product-form');
    const productDisplay = $('#product-display');

    // Handle form submission
    form.on('submit', function (e) {
        e.preventDefault();

        // Get form data
        const formData = new FormData(this);

        // Send data to the server
        $.ajax({
            url: 'upload_product.php',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function (response) {
                const result = JSON.parse(response);

                if (result.success) {
                    alert('Product added successfully!');
                    form[0].reset();
                    addProductToDisplay(result.product);
                } else {
                    alert('Error adding product: ' + result.message);
                }
            },
            error: function () {
                alert('An error occurred. Please try again later.');
            }
        });
    });

    // Function to dynamically add product to the display section
    function addProductToDisplay(product) {
        const productCard = $(
            `<div class="product-card">
                <img src="${product.image}" alt="${product.title}" class="product-image">
                <h3>${product.title}</h3>
                <p>${product.description}</p>
                <p><strong>Price:</strong> $${product.price}</p>
            </div>`
        );
        productDisplay.append(productCard);
    }
});
