<?php
session_start();
require 'headers.php';

/**
 * Adds a product review to the database.
 *
 * @param array $data The request data containing product_id and review text.
 * @return array The response message.
 */
function addReview($data) {
    global $pdo;


    $user_id = $_SESSION['unique_id'];

    // Validate required fields
    if (!isset($data['product_id']) || empty($data['product_id'])) {
        return ['success' => false, 'message' => 'Product ID is required'];
    }

    if (!isset($data['text']) || empty(trim($data['text']))) {
        return ['success' => false, 'message' => 'Review text is required'];
    }

    $product_id = $data['product_id'];
    $text = trim($data['text']);
    $created_at = date('Y-m-d H:i:s');

    try {
        // Insert review into database
        $stmt = $pdo->prepare("INSERT INTO reviews (product_id, user_id, text, created_at)
                               VALUES (:product_id, :user_id, :text, :created_at)");
        $stmt->execute([
            'product_id' => $product_id,
            'user_id' => $user_id,
            'text' => $text,
            'created_at' => $created_at
        ]);

        return ['success' => true, 'message' => 'Review submitted successfully'];
    } catch (PDOException $e) {
        return ['success' => false, 'message' => 'Error saving review'];
    }
}

// Get request data from frontend
$data = json_decode(file_get_contents('php://input'), true);

// Run the review insert function
$response = addReview($data);
echo json_encode($response);
?>
