<?php
require 'headers.php';

$data = json_decode(file_get_contents('php://input'), true);
$product_id = $data['product_id'] ?? null;

if (!$product_id) {
    echo json_encode(['success' => false, 'message' => 'Product ID is required']);
    exit;
}

$stripe = new \Stripe\StripeClient('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');

$conn = new mysqli('localhost', 'lxiernde_witty', 'Wittynail2024.', 'lxiernde_witty');

if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Database connection failed']));
}

try {
    // Get product and price from Stripe
    $product = $stripe->products->retrieve($product_id);
    $prices = $stripe->prices->all(['product' => $product_id]);
    $price = $prices->data[0] ?? null;

    // Get accessory details from 'product' table
    $stmt = $conn->prepare("SELECT pimg2, pimg3, pimg4, pimg5, created_at, category FROM product WHERE product_id = ?");
    $stmt->bind_param("s", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    $conn->close();

    // Extract DB images
    $db_images = [];
    if ($row) {
        for ($i = 2; $i <= 5; $i++) {
            $imgKey = "pimg$i";
            if (!empty($row[$imgKey])) {
                $db_images[] = $row[$imgKey];
            }
        }
    }

    $response = [
        'product_id' => $product->id,
        'name' => $product->name,
        'description' => $product->description,
        'images' => $product->images,     // Main Stripe image
        'pimg_extra' => $db_images,        // pimg2–pimg5
        'metadata' => $product->metadata,
        'price' => $price ? [
            'id' => $price->id,
            'unit_amount' => $price->unit_amount / 100,
            'currency' => strtoupper($price->currency),
        ] : null,
        'created_at' => $row['created_at'] ?? null,
        'category' => $row['category'] ?? null
    ];

    echo json_encode(['success' => true, 'data' => $response]);

} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching product details',
        'error' => $e->getMessage()
    ]);
}
?>
